---
title: Content Security Policy · Cloudflare Turnstile docs
description: The HTTP Content-Security-Policy response header allows website
  administrators to control resources the user agent is allowed to load for a
  given page.
lastUpdated: 2025-08-13T20:53:06.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/turnstile/reference/content-security-policy/
  md: https://developers.cloudflare.com/turnstile/reference/content-security-policy/index.md
---

The HTTP Content-Security-Policy response header allows website administrators to control resources the user agent is allowed to load for a given page.

We recommend using the nonce-based approach documented with [CSP3](https://w3c.github.io/webappsec-csp/#framework-directive-source-list). Make sure to include your nonce in the `api.js` script tag and we will handle the rest. Cloudflare Turnstile works with **strict-dynamic**.

Alternatively, add the following values to your CSP header:

* **script-src**: `https://challenges.cloudflare.com`
* **frame-src**: `https://challenges.cloudflare.com`

We recommend validating your CSP with [Google's CSP Evaluator](https://csp-evaluator.withgoogle.com/).

Note

You cannot set your own CSP and/or Referer-Policy via meta tags or [Transform rules](https://developers.cloudflare.com/rules/transform/) in challenge pages.

## Pre-clearance support

If you are using [Turnstile in pre-clearance mode](https://developers.cloudflare.com/cloudflare-challenges/concepts/clearance/#pre-clearance-support-in-turnstile), Turnstile sets the `cf_clearance` cookie by doing a fetch request to a special endpoint in [`/cdn-cgi/`](https://developers.cloudflare.com/fundamentals/reference/cdn-cgi-endpoint/) of your domain.

For this request to succeed, your `connect-src` directive must include `'self'`.
