---
title: Cloudflare Sensitive Data Detection · Cloudflare Web Application Firewall
  (WAF) docs
description: "The Cloudflare Sensitive Data Detection managed ruleset helps
  identify data leaks generated by your origin servers. Its rules run on the
  body of the response looking for patterns of common sensitive data,
  including:"
lastUpdated: 2025-10-17T11:29:44.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/managed-rules/reference/sensitive-data-detection/
  md: https://developers.cloudflare.com/waf/managed-rules/reference/sensitive-data-detection/index.md
---

Note

This feature requires an Enterprise plan with a paid add-on.

The Cloudflare Sensitive Data Detection managed ruleset helps identify data leaks generated by your origin servers. Its rules run on the body of the response looking for patterns of common sensitive data, including:

* [Personally identifiable information](https://www.cloudflare.com/learning/privacy/what-is-pii/) (PII) — For example, passport numbers.
* Financial information — For example, credit card numbers.
* Secrets — For example, API keys.

Turning on Cloudflare Sensitive Data Detection will not introduce additional latency, since the detection occurs outside the response path. For this reason, rules are always deployed with the *Log* action (you cannot block a response that was already sent), providing you with visibility on the sensitive data leaving your origin servers.

Some rules in the Cloudflare Sensitive Data Detection managed ruleset are disabled by default, to prevent false positives and a large number of logged events. You should review the PII and sensitive data relevant to your application and turn on the appropriate rules in the managed ruleset, according to the instructions in the following sections.

## Additional remarks

When turned on, Cloudflare Sensitive Data Detection will check all responses sent to visitors (according to your custom filter expression, if defined), including responses from cache and responses handled by [Workers](https://developers.cloudflare.com/workers/).

The detection will handle text, HTML, JSON, and XML content in the response up to 1 MB.

Currently, Cloudflare Sensitive Data Detection does not support [matched payload logging](https://developers.cloudflare.com/waf/managed-rules/payload-logging/).

***

## Configure in the dashboard

* Old dashboard

  To configure Cloudflare Sensitive Data Detection in the Cloudflare dashboard, go to **Security** > **Sensitive Data**.

  You can turn the managed ruleset on or off, and configure the following settings:

  * Turn on or off specific rules or rules with specific tags.
  * Customize the filter expression. With a custom expression, Cloudflare Sensitive Data Detection applies only to a subset of the incoming requests.

* New dashboard

  To enable Cloudflare Sensitive Data Detection:

  1. In the Cloudflare dashboard, go to the Security **Settings** page.

     [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/:zone/security/settings)

  2. (Optional) Filter by **Detections tools**.

  3. Turn on **Sensitive data detection**.

  To adjust the scope of the managed ruleset or turn off specific rules:

  1. In the **Settings** page, under **Sensitive data detection**, select **Configured ruleset**.
  2. To apply the managed ruleset for a subset of incoming requests, select **Custom filter expression** and define the filter expression.
  3. Select **Next**.
  4. To turn specific rules on or off, select **Browse rules** and use the toggle next to each rule to turn it on or off.
  5. Select **Next**, and then select **Save**.

For details on configuring a managed ruleset in the dashboard, refer to [Configure a managed ruleset](https://developers.cloudflare.com/waf/managed-rules/deploy-zone-dashboard/#configure-a-managed-ruleset).

## Configure via API

To enable Cloudflare Sensitive Data Detection for a given zone using the API, create a rule with `execute` action in the [entry point ruleset](https://developers.cloudflare.com/ruleset-engine/about/rulesets/#entry-point-ruleset) for the `http_response_firewall_managed` phase.

### Example

This example deploys the Cloudflare Sensitive Data Detection managed ruleset to the `http_response_firewall_managed` phase of a given zone (`$ZONE_ID`) by creating a rule that executes the managed ruleset. The rules in the managed ruleset are executed for all incoming requests.

1. Invoke the [Get a zone entry point ruleset](https://developers.cloudflare.com/api/resources/rulesets/subresources/phases/methods/get/) operation to obtain the definition of the entry point ruleset for the `http_response_firewall_managed` phase. You will need the [zone ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) for this task.

   ```bash
   curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/phases/http_response_firewall_managed/entrypoint" \
     --request GET \
     --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN"
   ```

   ```json
   {
     "result": {
       "description": "Zone-level phase entry point (response)",
       "id": "<RULESET_ID>",
       "kind": "zone",
       "last_updated": "2024-03-16T15:40:08.202335Z",
       "name": "zone",
       "phase": "http_response_firewall_managed",
       "rules": [
         // ...
       ],
       "source": "firewall_managed",
       "version": "10"
     },
     "success": true,
     "errors": [],
     "messages": []
   }
   ```

2. If the entry point ruleset already exists (that is, if you received a `200 OK` status code and the ruleset definition), take note of the ruleset ID in the response. Then, invoke the [Create a zone ruleset rule](https://developers.cloudflare.com/api/resources/rulesets/subresources/rules/methods/create/) operation to add an `execute` rule to the existing ruleset deploying the Cloudflare Sensitive Data Detection managed ruleset (with ID `e22d83c647c64a3eae91b71b499d988e`). By default, the rule will be added at the end of the list of rules already in the ruleset.

   ```bash
   curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets/$RULESET_ID/rules" \
     --request POST \
     --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
     --json '{
       "action": "execute",
       "action_parameters": {
           "id": "e22d83c647c64a3eae91b71b499d988e"
       },
       "expression": "true",
       "description": "Execute the Cloudflare Sensitive Data Detection managed ruleset"
     }'
   ```

   ```json
   {
     "result": {
       "id": "<RULESET_ID>",
       "name": "Zone-level phase entry point (response)",
       "description": "",
       "kind": "zone",
       "version": "11",
       "rules": [
         // ... any existing rules
         {
           "id": "<RULE_ID>",
           "version": "1",
           "action": "execute",
           "action_parameters": {
             "id": "e22d83c647c64a3eae91b71b499d988e",
             "version": "latest"
           },
           "expression": "true",
           "description": "Execute the Cloudflare Sensitive Data Detection managed ruleset",
           "last_updated": "2024-03-18T18:08:14.003361Z",
           "ref": "<RULE_REF>",
           "enabled": true
         }
       ],
       "last_updated": "2024-03-18T18:08:14.003361Z",
       "phase": "http_response_firewall_managed"
     },
     "success": true,
     "errors": [],
     "messages": []
   }
   ```

3. If the entry point ruleset does not exist (that is, if you received a `404 Not Found` status code in step 1), create it using the [Create a zone ruleset](https://developers.cloudflare.com/api/resources/rulesets/methods/create/) operation. Include a single rule in the `rules` array that executes the Cloudflare Sensitive Data Detection managed ruleset (with ID `e22d83c647c64a3eae91b71b499d988e`) for all incoming requests in the zone.

   ```bash
   curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/rulesets" \
     --request POST \
     --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
     --json '{
       "name": "My ruleset",
       "description": "Entry point ruleset for WAF managed rulesets (response)",
       "kind": "zone",
       "phase": "http_response_firewall_managed",
       "rules": [
           {
               "action": "execute",
               "action_parameters": {
                   "id": "e22d83c647c64a3eae91b71b499d988e"
               },
               "expression": "true",
               "description": "Execute the Cloudflare Sensitive Data Detection managed ruleset"
           }
       ]
     }'
   ```

### Next steps

To configure the Cloudflare Sensitive Data Detection managed ruleset via API, create [overrides](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/override-managed-ruleset/) using the Rulesets API. You can perform the following configurations:

* Disable individual rules by creating rule overrides.

For examples of creating overrides using the API, refer to [Override a managed ruleset](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/override-managed-ruleset/).

### More resources

For more information on working with managed rulesets via API, refer to [Work with managed rulesets](https://developers.cloudflare.com/ruleset-engine/managed-rulesets/) in the Ruleset Engine documentation.

## Review detected leaks

To check for any data leaks detected by Cloudflare Sensitive Data Detection, you can do the following:

* Regularly check [Security Events](https://developers.cloudflare.com/waf/analytics/security-events/) for any events generated by the managed ruleset.
* Configure [WAF alerts](https://developers.cloudflare.com/waf/reference/alerts/) to be alerted of any spike of WAF events. For the Advanced Security Events Alert, you can filter by one or more domains on Enterprise plans and by the `Data Loss Protection` service to receive specific alerts about Sensitive Data Detection.
